#ifndef __CBounds__
#define __CBounds__

#include "../Basics/CCountedObject.hpp"

//	===========================================================================

namespace Exponent
{
	namespace MathTools
	{
		/**
		 * @class CBounds CBounds.hpp
		 * @brief Ensure certain ranges are adhered to
		 *
		 * @date 13/11/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CBounds.hpp,v 1.4 2007/02/08 21:06:44 paul Exp $
		 */
		class CBounds
		{
		public:

//	===========================================================================

			/**
			 * Ensure the range of a double
			 * @param value The value to clamp
			 * @param min The min value it can have
			 * @param max The max value it can have
			 * @retval double The clamped value
			 */
			static FORCEINLINE double ensureRange(double value, const double min, const double max)
			{
				if (value > max)
				{
					return max;
				}
				else if (value < min)
				{
					return min;
				}
				return value;
			}

			/**
			 * Ensure the range of a long
			 * @param value The value to clamp
			 * @param min The min value it can have
			 * @param max The max value it can have
			 * @retval long The clamped value
			 */
			static FORCEINLINE long ensureRange(const long value, const long min, const long max)
			{
				if (value > max)
				{
					return max;
				}
				else if (value < min)
				{
					return min;
				}
				return value;
			}

			/**
			 * Ensure the range of a long
			 * @param value The value to clamp, on return holds the clamped value
			 * @param min The min value it can have
			 * @param max The max value it can have
			 * @retval long The clamped value
			 */
			static FORCEINLINE void clampRange(double &value, const double min, const double max)
			{
				if (value > max)
				{
					value = max;
				}
				else if (value < min)
				{
					value = min;
				}
			}

			/**
			 * Range check a value (same as calling CBounds::ensureRange(value, 0.0, 1.0))
			 * @param value The value to clamp
			 * @retval double Value in range 0 - 1
			 */
			static FORCEINLINE double rangeCheck(const double value)
			{
				return ensureRange(value, 0.0, 1.0);
			}

		};
	}
}
#endif	// End of CBounds.hpp